/*
 The Techlabs Pure MVC Tutorial
 Copyright (c) 2009 Pedro Furtado (pedro.furtado@gmail.com)
 Your reuse is governed by the Creative Commons Attribution 3.0 License
*/

package com.techlabs.puremvc.controller
{
	import com.techlabs.puremvc.model.DataProxy;
	
	import org.puremvc.as3.interfaces.INotification;
	import org.puremvc.as3.patterns.command.SimpleCommand;

	public class AddFeedCommand extends SimpleCommand
	{
		/**
         * Adds a feed to by affecting the feeds in dataProxy
         */
		override public function execute( note:INotification ) :void    
		{
			var dataProxy:DataProxy = facade.retrieveProxy(DataProxy.NAME) as DataProxy;
			dataProxy.feeds.addItem(note.getBody())
			dataProxy.saveData()
        }
		
	}
}